/* --COPYRIGHT--,BSD_EX
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 *
 *                       MSP430 CODE EXAMPLE DISCLAIMER
 *
 * MSP430 code examples are self-contained low-level programs that typically
 * demonstrate a single peripheral function or device feature in a highly
 * concise manner. For this the code may rely on the device's power-on default
 * register values and settings such as the clock configuration and care must
 * be taken when combining code from several examples to avoid potential side
 * effects. Also see www.ti.com/grace for a GUI- and www.ti.com/msp430ware
 * for an API functional library-approach to peripheral configuration.
 *
 * --/COPYRIGHT--*/
/*
 * LCD.h
 *
 *  Created on: May 25, 2020
 *      Author: JD Crutchfield
 */

#ifndef MSP430I2040_LCD_H_
#define MSP430I2040_LCD_H_

/* function declarations*/
void InitLCD(void);
void LCDStatemachineProcess(void);
void LcdDisplayLowBattery(void);
void LcdDisplayError(void);
void LcdDisplayTemperature(unsigned long, char);

//LCD COM Port, Pins, channels, and toggle macros for LCD waveform
#define NUMBER_OF_COMx_CHANNELS     4
#define COMportDIR P2DIR
#define COMportOUT P2OUT
#define COM0_BIT BIT3   //P2.3
#define COM1_BIT BIT4   //P2.4
#define COM2_BIT BIT5   //P2.5
#define COM3_BIT BIT6   //P2.6

#define COM0 0
#define COM1 1
#define COM2 2
#define COM3 3

#define SET_COM_AS_OUTPUT(com_x_bit)    COMportDIR &= ~(COM0_BIT+ COM1_BIT+ COM2_BIT+ COM3_BIT); COMportDIR|=com_x_bit;
#define SET_COM_HIGH(com_x_bit)         COMportOUT |= com_x_bit;
#define SET_COM_LOW(com_x_bit)          COMportOUT &= ~com_x_bit;

#define DEAD_TIME_PERCENT   0


//LCD Waveform timing states
enum LCD_Waveform_timing{ T0, T1, T2, T3, T4, T5, T6, T7, DEAD_TIME};

//macro for setting correct LCD segment for decimal point
#define DECIMAL_POINT_SEGMENT       BIT7



#endif /* MSP430I2040_LCD_H_ */



